////////////////////////////////////////////////////////
// filename: CustomButton.h
// author: Taketoshi Anami
// version: 1.0.0
// date: 2016/10/15
////////////////////////////////////////////////////////

#ifndef __CUSTOMBUTTON_H__
#define __CUSTOMBUTTON_H__

class CBaseButton {
public:

	HWND		m_hWnd;

	int			Width;
	int			Height;
	int			PosX;
	int			PosY;

	bool			LButtonDown;
	bool			InAction;
	int			ButtonType;

	UINT				ButtonID;

	ID2D1Bitmap* Img_Normal;
	ID2D1Bitmap* Img_NormalMouseDown;
	ID2D1Bitmap* Img_InActionNormal;
	ID2D1Bitmap* Img_InActionMouseDown;

	CBaseButton();
	~CBaseButton();
	bool SetImage(ID2D1Bitmap* normal_img, ID2D1Bitmap* normal_down, ID2D1Bitmap* in_action_normal, ID2D1Bitmap* in_action_down);
	bool CreateWnd(HWND ParentWnd, int x, int y, int w, int h);
	bool D2D1Draw( ID2D1HwndRenderTarget *render_target, int x, int y, int w, int h);
	bool Action();
	bool Stop();

private:
	void OnPaint();
	void OnLButtonDown(UINT nFlags, CPoint point);
	void OnLButtonUp(UINT nFlags, CPoint point);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT ButtonProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

#endif
