////////////////////////////////////////////////////////
// filename: MainWindow.h
// author: 
// version: 1.0.0
// date: 2025/10/31
////////////////////////////////////////////////////////

#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

class CControlWindow;
class CVideoPanel;
class CVideoPopUpWnd;

extern bool MFVideoReady;
extern bool	SeekProcessing;

class CMainWindow {
public:

	HWND				m_hWnd;
	CVideoPanel 	*VideoPanel;
	CVideoPopUpWnd* VideoPopUpWnd;
	CControlWindow		*ControlWnd;

	bool AppExit;
	HANDLE	m_hThread;

	ID2D1HwndRenderTarget* g_pRenderTarget;

	IMFVideoRenderer* pVideoRenderer;
	IMFVideoDisplayControl* pVideoDisplay;
	IMFMediaSession* m_session;
	IMFMediaSource* m_source;
	IMFTopology* m_topology;
	IMFAsyncCallback* pCallback;
	IMFAudioStreamVolume* pAudioVolume;

	wchar_t		Path[SIZE_CHAR_MAX];
	wchar_t		TmpPath[SIZE_CHAR_MAX];
	wchar_t		FileName[SIZE_CHAR_MAX];
	wchar_t		Ext[SIZE_CHAR_MAX];

	int		FirstFrameWidth, FirstFrameHeight;
	IWICBitmap		*FirstFrameBMP;

	LONGLONG		Length;
	LONGLONG		NowPos;
	ComPtr <IMFClock> pClock;

	std::vector <ComPtr<ID2D1Bitmap>> D2D1Bitmaps;
	std::vector <ComPtr<IWICBitmap>> WICBitmaps;
	std::vector <wchar_t*> BitmapPath;
	std::vector <wchar_t*> BitmapNames;
	std::vector <int> Delays;
	std::vector <int> Disposal;
	std::vector <D2D1_RECT_F> bmpRects;

	ID2D1Bitmap* AppIcon;

	HANDLE	m_pThread;
	int			TotalImageNum;
	int			CurrentImageNum;

	UINT		TimerID;
	UINT		pFrameCount;
	UINT		CurrentFrameCount;
	float			bmpWidth, bmpHeight;

	UINT32	VideoQuarity;
	int			MediaType;
	bool			Playing;
	bool			Pausing;

	int			DisplayWidth, DisplayHeight;
	bool			LButtonDown;
	bool			ControlShow;

public:
	CMainWindow();
	~CMainWindow();
	bool CreateWnd();
	bool D2D1Draw();
	bool SetCursor(bool show);
	bool OpenMedia();
	bool LoadDirectoryImages();
	bool BeginImgLoadThread();
	bool GifAnimationStart();
	bool RepairExtention(wchar_t* path);
	bool Open();
	bool Play();
	bool Pause();
	bool Seek(LONGLONG pos);
	bool Stop();
	bool Close();
	bool Resume();
	bool GetExtention(wchar_t* filename, wchar_t *extention );
	void NV12ToRGB32(BYTE* pNV12, int width, int height, BYTE* pRGB);
	bool GetFirstFrame(wchar_t *path);
	void RotateRGB32(BYTE* src, BYTE* dst, int width, int height, UINT32 rotation);
	bool GetClientRect(BYTE* bmp, RECT* rect, int width, int height);
	static unsigned LoadImages(void* Param);
	static void CALLBACK VideoProcessCheckCallBack(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
	static void CALLBACK GifAnimationCallBack(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);

private:
	void OnPaint();
	void OnClose();
	void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	void OnLButtonDown(UINT nFlags, CPoint point);
	void OnLButtonUp(UINT nFlags, CPoint point);
	void OnMouseMove(UINT nFlags, CPoint point);
	BOOL OnNcActivate(BOOL bActive);
	LRESULT VideoProcessStart();
	LRESULT VideoProcessEnd();
	LRESULT VideoProcessEnding();
	HRESULT CreateMediaSourceFromFile(LPCWSTR filename, IMFMediaSource** pSource);
	HRESULT SetMediaSource(IMFMediaSource* pSource);
	HRESULT CreateTopologyForSource(IMFMediaSource* pSource, IMFTopology** ppTopology, TOPOID* videoSinkNodeID, TOPOID* audioSinkNodeID);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT MainWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

bool naturalLess(const std::wstring& a, const std::wstring& b);
unsigned long long readNumber(const std::wstring& s, size_t& i);

class CMediaSessionCallback : public IMFAsyncCallback {

	long m_refCount;
	IMFMediaSession* m_pSession;
	IMFTopology* m_pTopology;
	TOPOID m_videoSinkNodeID, m_audioSinkNodeID;
	IMFVideoDisplayControl** m_pVideoDisplay;
	IMFAudioStreamVolume** m_pAudioVolume;

public:

	HWND m_hVideoWnd = nullptr;

	CMediaSessionCallback(IMFMediaSession* pSession, IMFTopology* pTopology, TOPOID videoSinkNodeID, TOPOID audioSinkNodeID, HWND hWnd, IMFVideoDisplayControl** pVideoDisplay, IMFAudioStreamVolume** pAudioVolume) : m_refCount(1), m_pSession(pSession), m_pTopology(pTopology), m_videoSinkNodeID(videoSinkNodeID), m_audioSinkNodeID(audioSinkNodeID), m_hVideoWnd(hWnd), m_pVideoDisplay(pVideoDisplay), m_pAudioVolume(pAudioVolume) {
		if (m_pSession) m_pSession->AddRef();
		if (m_pTopology) m_pTopology->AddRef();
	}

	~CMediaSessionCallback() {
		if (m_pSession) m_pSession->Release();
		if (m_pTopology) m_pTopology->Release();
	}

	STDMETHODIMP QueryInterface(REFIID riid, void** ppv) {

		if (ppv == nullptr)
			return E_POINTER;

		if (riid == IID_IUnknown || riid == __uuidof(IMFAsyncCallback)) {

			*ppv = static_cast<IMFAsyncCallback*>(this);
			AddRef();

			return S_OK;
		}
		*ppv = nullptr;

		return E_NOINTERFACE;
	}

	STDMETHODIMP_(ULONG) AddRef() { return InterlockedIncrement(&m_refCount); }
	STDMETHODIMP_(ULONG) Release() {

		ULONG u = InterlockedDecrement(&m_refCount);
		if (u == 0)
			delete this;

		return u;
	}

	STDMETHODIMP GetParameters(DWORD* pdwFlags, DWORD* pdwQueue) {

		if (pdwFlags) *pdwFlags = 0;
		if (pdwQueue) *pdwQueue = MFASYNC_CALLBACK_QUEUE_STANDARD;

		return S_OK;
	}

	STDMETHODIMP Invoke(IMFAsyncResult* pAsyncResult) {

		ComPtr<IMFMediaEvent> pEvent;
		HRESULT hr = m_pSession->EndGetEvent(pAsyncResult, &pEvent);
		if (FAILED(hr))
			return hr;

		MediaEventType meType;
		pEvent->GetType(&meType);
		if (meType == MESessionTopologyStatus) {

			UINT32 status = 0;
			pEvent->GetUINT32(MF_EVENT_TOPOLOGY_STATUS, &status);
			if (status == MF_TOPOSTATUS_READY) {

				ComPtr<IMFTopologyNode> pNode;
				hr = m_pTopology->GetNodeByID(m_videoSinkNodeID, &pNode);
				if (SUCCEEDED(hr)) {

					ComPtr<IUnknown> pObj;
					hr = pNode->GetObject(&pObj);
					if (SUCCEEDED(hr)) {

						ComPtr<IMFGetService> pGetService;
						hr = pObj.As(&pGetService);
						if (SUCCEEDED(hr)) {

							hr = pGetService->GetService( MR_VIDEO_RENDER_SERVICE, IID_PPV_ARGS(m_pVideoDisplay));
							if (SUCCEEDED(hr)) {

								(*m_pVideoDisplay)->SetVideoWindow(m_hVideoWnd);
								(*m_pVideoDisplay)->SetAspectRatioMode(MFVideoARMode_PreservePicture);

							}
						}
					}
				}

				hr = m_pTopology->GetNodeByID(m_audioSinkNodeID, &pNode);
				if (SUCCEEDED(hr)) {

					ComPtr<IUnknown> pObj;
					hr = pNode->GetObject(&pObj);
					if (SUCCEEDED(hr)) {

						ComPtr<IMFGetService> pGetService;
						hr = pObj.As(&pGetService);
						if (SUCCEEDED(hr)) {

							hr = pGetService->GetService(MR_STREAM_VOLUME_SERVICE, IID_PPV_ARGS(m_pAudioVolume));
						}
					}
				}

				PostMessage(m_hVideoWnd, WM_APP_VIDEO_READY, 0, 0);
			}
		}
		else if (meType == MESessionStarted) {

			::SendMessage(theApp->MainWindow->m_hWnd, WM_APP_MEDIA_START, 0, 0);
		}
		else if (meType == MEEndOfPresentation) {

			::SendMessage(theApp->MainWindow->m_hWnd, WM_APP_MEDIA_ENDING, 0, 0);
		}
		else if (meType == MESessionEnded) {

			::SendMessage(m_hVideoWnd, WM_APP_MEDIA_ENDED, 0, 0);
		}

		m_pSession->BeginGetEvent(this, nullptr);

		return S_OK;
	}
};

#endif